% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitbit_utils.R
\name{extract_LOG_ID}
\alias{extract_LOG_ID}
\title{Extract the log-id (it's possible that I receive more than one id)}
\usage{
extract_LOG_ID(
  user_id,
  token,
  after_Date = "2021-03-13",
  limit = 10,
  sort = "asc",
  verbose = FALSE
)
}
\arguments{
\item{user_id}{a character string specifying the encoded ID of the user. For instance '99xxxx' of the following URL 'https://www.fitbit.com/user/99xxxx' of the user's account corresponds to the 'user_id'}

\item{token}{a character string specifying the secret token that a user receives when registers a new application in https://dev.fitbit.com/apps}

\item{after_Date}{a character string specifying the Date after which the log-ids will be returned. For instance, the date '2021-12-31' where the input order is 'year-month-day'}

\item{limit}{an integer specifying the total of log-id's to return. The default value is 10}

\item{sort}{a character string specifying the order ('asc', 'desc') based on which the output log-id's should be sorted}

\item{verbose}{a boolean. If TRUE then information will be printed out in the console}
}
\value{
an integer specifying the log ID
}
\description{
Extract the log-id (it's possible that I receive more than one id)
}
\examples{

\dontrun{

require(fitbitViz)

USER_ID = '99xxxx'
token = 'my_long_web_api_token'

log_id = extract_LOG_ID(user_id = USER_ID,
                        token = token,
                        after_Date = '2021-03-13',
                        limit = 10,
                        sort = 'asc',
                        verbose = TRUE)
log_id

}
}
