% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull_sigmoidal.R
\name{fsigmoidal}
\alias{fsigmoidal}
\title{Sigmoidal vulnerability curve}
\usage{
fsigmoidal(P, PX, a, X = 50)
}
\arguments{
\item{P}{Water potential (positive-valued MPa)}

\item{PX}{Water potential at X loss of conductivity (positive valued).}

\item{a}{Shape parameter, related to the slope at the inflection point (see Description).}

\item{X}{If 50, PX is the P50.}
}
\description{
A sigmoidal-exponential function, which describes the relative conductivity as a function of the plant water potential. The relative conductivity is scaled to be 1 when water potential is zero. This function was used by Pammenter and vander Willigen (1998), but note that this implementation gives the relative conductivity, not the PLC (but relK = 1 - PLC). The slope of relK versus P at the inflection point can be calculated from the shape parameter (a) as slope = -a/4.
}
\examples{
curve(fsigmoidal(x, PX=-2, a=5), from=0, to=-5)
curve(fsigmoidal(x, PX=-2, a=2), add=TRUE)

# Comparison to Weibull
curve(fweibull(x, PX=3, SX=40), from=0, to=6)
curve(fsigmoidal(x, PX=3, a=4*(40/100)), add=TRUE, col="red")
}
\references{
Pammenter, N.W., Willigen, C.V. der, 1998. A mathematical and statistical analysis of the curves illustrating vulnerability of xylem to cavitation. Tree Physiol 18, 589-593. doi:10.1093/treephys/18.8-9.589
}
