% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{base_pub}
\alias{base_pub}
\title{Publication data sample}
\format{
\code{base_pub} is a data frame with 4,024 observations and 10 variables. There are 200 different scientists and 51 different years (ends in 2000).
\itemize{
\item \code{author_id}: scientist identifier
\item \code{year}: current year
\item \code{affil_id}: affiliation ID of the scientist's current affiliation
\item \code{affil_name}: affiliation name of the scientist's current affiliation (character)
\item \code{field}: field name of the scientist (character), time invariant
\item \code{nb_pub}: number of publications of the scientist for the current year
\item \code{nb_cites}: number of citations received by the publications of the scientist in the current year. Accounts for the citations received from articles published up to 2020.
\item \code{birth_year}: birth year of the scientist (this is randomly generated)
\item \code{is_woman}: 1 if the scientist is a woman, 0 otherwise (this is randomly generated)
\item \code{age}: current age of the scientist (formally \code{year - birth_year})
}
}
\source{
The source of this data set is the Microsoft Academic Graph data set, extracted in 2020. Now a defunct project, you can find similar data on \href{https://docs.openalex.org/}{OpenAlex}.

The variables \code{birth_year}, \code{is_woman} and \code{age} were randomly generated. All other variables have created from the raw MAG files.
}
\usage{
data(base_pub, package = "fixest")
}
\description{
This data reports the publication output (number of articles and number of citations received)
for a few scientists from the start of their career to 2000.
Most of the variables are processed from the Microsoft Academic Graph (MAG) data set. A few variables are randomly generated.
}
\keyword{datasets}
