% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flash_factors_fix.R
\name{flash_factors_fix}
\alias{flash_factors_fix}
\title{Fix flash factors}
\usage{
flash_factors_fix(
  flash,
  kset,
  which_dim = c("factors", "loadings"),
  fixed_idx = NULL,
  use_fixed_in_ebnm = NULL
)
}
\arguments{
\item{flash}{A \code{flash} or \code{flash_fit} object.}

\item{kset}{A vector of integers indexing the factor/loadings pairs whose
loadings or factors are to be fixed.}

\item{which_dim}{Whether to fix factors or loadings.}

\item{fixed_idx}{If \code{fixed_idx = NULL}, then all loadings or factor
values will be fixed. If only a subset are to be fixed,
then \code{fixed_idx} should be an appropriately-sized vector or
matrix of values that can be coerced to logical. For example, if
a subset of loadings for two factor/loadings pairs are to be fixed, then
\code{fixed_idx} should be a length-\eqn{n} vector or an \eqn{n} by 2
matrix (where \eqn{n} is the number of rows in the data matrix).}

\item{use_fixed_in_ebnm}{By default, fixed elements are ignored when
solving the EBNM subproblem in order to estimate the prior \eqn{\hat{g}}.
This behavior can be changed by setting \code{use_fixed_in_ebnm = TRUE}.
This is a global setting which applies to all factor/loadings pairs;
behavior cannot vary from one factor/loadings pair to another.}
}
\value{
The \code{\link{flash}} object from argument \code{flash}, with
  factors or loadings fixed as specified.
}
\description{
Fixes loadings \eqn{\ell_{\cdot k}} or factors \eqn{f_{\cdot k}}
  for one or more factor/loadings pairs, so that their values are not
  updated during subsequent backfits. For a given pair, either the loadings
  or factor can be fixed, but not both, and either all entries or a subset
  can be fixed. To unfix, use function \code{\link{flash_factors_unfix}}. See
  \code{\link{flash_factors_init}} for an example of usage.
}
