% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_importance.R
\name{most_important}
\alias{most_important}
\title{Most Important Variables.}
\usage{
most_important(x, top_m = Inf)
}
\arguments{
\item{x}{An object of class "light_importance".}

\item{top_m}{Maximum number of important variables to be returned.}
}
\value{
A character vector of variable names sorted in descending importance.
}
\description{
Returns the most important variable names sorted descendingly.
}
\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
fl <- flashlight(model = fit, label = "lm", data = iris, y = "Sepal.Length")
imp <- light_importance(fl)
most_important(imp)
most_important(imp, top_m = 2)
}
\seealso{
\code{\link[=light_importance]{light_importance()}}
}
