% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table.R
\name{remove_empty}
\alias{remove_empty}
\alias{remove_empty.pivot_table}
\title{Remove empty rows and columns from a pivot table}
\usage{
remove_empty(pt)

\method{remove_empty}{pivot_table}(pt)
}
\arguments{
\item{pt}{A \code{pivot_table} object.}
}
\value{
A \code{pivot_table} object.
}
\description{
Remove rows and columns without data from the pivot table represented by the
object.
}
\details{
A pivot table should only contain label rows and columns, and an array of
values, usually numeric data.

All rows and columns not belonging to the pivot table must be removed,
including those without data.
}
\examples{

df <- df_ex
df[seq(from = 1, to = 25, by = 2), ] <- " "
df[, seq(from = 1, to = 7, by = 2)] <- " "
pt <- pivot_table(df)
pt <- pt |> remove_empty()

}
\seealso{
\code{\link{pivot_table}}

Other pivot table transformation functions: 
\code{\link{extract_labels}()},
\code{\link{fill_labels}()},
\code{\link{fill_values}()},
\code{\link{remove_agg}()},
\code{\link{remove_bottom}()},
\code{\link{remove_cols}()},
\code{\link{remove_k}()},
\code{\link{remove_left}()},
\code{\link{remove_right}()},
\code{\link{remove_rows}()},
\code{\link{remove_top}()},
\code{\link{replace_dec}()},
\code{\link{unpivot}()}
}
\concept{pivot table transformation functions}
