% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{sampleQ}
\alias{sampleQ}
\title{Sample function with fixed quantiles}
\usage{
sampleQ(x, size, quantiles, replace = FALSE, prob = NULL)
}
\arguments{
\item{x}{a vector of one or more elements from which to choose.}

\item{size}{a non-negative integer giving the number of items to choose.}

\item{quantiles}{1D array containing values drawn in U(0,1).
Length has to be equal to size.}

\item{replace}{should sampling be with replacement ?}

\item{prob}{a vector of probability weights for obtaining
the elements of the vector being sampled.}
}
\value{
a vector of length size with elements drawn from x.
}
\description{
Replace the sample function in the context of fixed quantiles.
Warning : first argument has less features.
}
\examples{

set.seed(1)
quantiles <- runif(40)
sampleQ(1:10, 10, quantiles[1:10])
sampleQ(1:10, 10, quantiles[11:20])
sampleQ(11:20, 10, quantiles[1:10])
sampleQ(1:10, 20, quantiles[21:40], replace = TRUE)

}
