% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regional_evi.R
\name{hill}
\alias{hill}
\title{Hill's estimator}
\usage{
hill(x, k)
}
\arguments{
\item{x}{Vector or matrix of observations}

\item{k}{Number of relative excesses involved in the estimation of the extreme value
index gamma. If \code{k} is missing, it will be set to \itemize{
 \item \eqn{k=\left\lfloor 2n^{2/3}\right\rfloor}{k=floor(2*n^(2/3))}, where n is the
sample length of the vector \code{x} after removing missing values
 \item \eqn{k=\left\lfloor \frac{2n^{2/3}}{d^{1/3}}\right\rfloor}{k=floor(2*n^(2/3)/d^(1/3))}, where d is the number of
 columns of the matrix \code{x} and n the length of each column after removing missing values.}}
}
\value{
Hill's estimator for each sample.
}
\description{
Estimation of heavy tails with Hill's estimator
}
\examples{
library("evd")
x1 <- rgev(100, loc = 2, scale = 1, shape=0.4)
hill(x1, k=20)
x2 <- rgev(100, loc = 2, scale = 1, shape=0.5)
hill(cbind(x1, x2), k = c(20, 25))
x2[c(4,8,39)] <- NA
hill(cbind(x1, x2), k=c(20, 25))
# if leaving out k, it will be set to floor(2*n^(2/3)/d^(1/3)) = c(34,33):
hill(cbind(x1, x2)) # is the same as:
hill(cbind(x1, x2), k=c(34,33))
}

