% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow_embed.R
\name{flow_embed}
\alias{flow_embed}
\title{Embed chart in roxygen doc}
\usage{
flow_embed(call, name, width = 1, alt = name)
}
\arguments{
\item{call}{A call to a flow function, prefixed with \verb{flow::}}

\item{name}{A name for the png file that will be created under 'man/figures',
without extension.}

\item{width}{width, relative if < 1, pixels otherwise}

\item{alt}{alt text}
}
\value{
Called for side effects, should only be used in roxygen doc
}
\description{
Include a call \code{`r_flow::flow_embed(...)`} in your doc and a diagram will be
included.
}
\details{
\itemize{
\item As with images in general the image might not be visible when viewing
temp doc with the devtools workflow.
\item Don't forget to add {flow} to Suggests in your DESCRIPTION file.
\item We don't monitor files created under 'man/figures', so if you remove a
diagram from the doc make sure to also remove it from the folder.
\item We also don't overwrite created files, so we don't slow down the documentation
process, so if you want to print a different diagram for the same name remove
the file first.
}
}
