% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketInfo.R
\name{fmpc_security_screener}
\alias{fmpc_security_screener}
\title{Stock Screener}
\usage{
fmpc_security_screener(
  limit = 100,
  mrktCapAbove = NULL,
  mrktCapBelow = NULL,
  betaAbove = NULL,
  betaBelow = NULL,
  dividendAbove = NULL,
  dividendBelow = NULL,
  volumeAbove = NULL,
  volumeBelow = NULL,
  sector = NULL,
  industry = NULL
)
}
\arguments{
\item{limit}{limit output to a certain amount or rows}

\item{mrktCapAbove}{integer - market cap greater than}

\item{mrktCapBelow}{integer - market cap less than}

\item{betaAbove}{double - beta greater than}

\item{betaBelow}{double - beta less than}

\item{dividendAbove}{double - dividend greater than}

\item{dividendBelow}{double - dividend less than}

\item{volumeAbove}{integer - volume in shares greater than}

\item{volumeBelow}{integer - volume in shares less than}

\item{sector}{indicate a sector. Documentation is unclear of options. 'tech'
is the example used}

\item{industry}{indicate an industry. Documentation is unclear of options.
'Software' is the example used}
}
\value{
a list of securities based on criteria supplied
}
\description{
Filter for stocks based on numerous criteria.
}
\details{
This function will temporarily modify options(scipen=999).
}
\examples{
\dontrun{

# Must set a valid API token
fmpc_set_token('FMPAPIKEY')
fmpc_security_screener() # Default pulls a list of 100 with no filters
# Search for market cap above a billion,
# that trades at least a million shares with a dividend under 1
fmpc_security_screener(mrktCapAbove = 1e9, dividendBelow = 1, volumeAbove = 1e6)

}

}
