% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf.R
\name{HRF}
\alias{HRF}
\title{HRF Constructor Function}
\usage{
HRF(fun, name, nbasis = 1, span = 24, param_names = NULL)
}
\arguments{
\item{fun}{A function representing the hemodynamic response, mapping from time to BOLD response.}

\item{name}{A string specifying the name of the function.}

\item{nbasis}{An integer representing the number of basis functions, e.g., the columnar dimension of the HRF. Default is 1.}

\item{span}{A numeric value representing the span in seconds of the HRF. Default is 24.}

\item{param_names}{A character vector containing the names of the parameters for the HRF function.}
}
\value{
An HRF object with the specified properties.
}
\description{
The `HRF` function creates an object representing a hemodynamic response function (HRF). It is a class constructor for HRFs.
}
\details{
The package provides several pre-defined HRF types that can be used in modeling fMRI responses:

**Canonical HRFs:**
* `"spmg1"` or `HRF_SPMG1`: SPM's canonical HRF (single basis function)
* `"spmg2"` or `HRF_SPMG2`: SPM canonical + temporal derivative (2 basis functions)
* `"spmg3"` or `HRF_SPMG3`: SPM canonical + temporal and dispersion derivatives (3 basis functions)
* `"gaussian"` or `HRF_GAUSSIAN`: Gaussian-shaped HRF with peak around 5-6s
* `"gamma"` or `HRF_GAMMA`: Gamma function-based HRF with longer tail

**Flexible basis sets:**
* `"bspline"` or `"bs"` or `HRF_BSPLINE`: B-spline basis for flexible HRF modeling
* `"tent"`: Tent (triangular) basis functions for flexible HRF modeling
* `"daguerre"` or `HRF_DAGUERRE`: Daguerre basis functions

To see a complete list of available HRF types with details, use the `list_available_hrfs()` function.
}
\examples{
hrf <- HRF(hrf_gamma, "gamma", nbasis=1, param_names=c("shape", "rate"))
resp <- evaluate(hrf, seq(0, 24, by=1))

# List all available HRF types
list_available_hrfs(details = TRUE)

}
