% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_peaks}
\alias{plot_peaks}
\title{Plot Peaks}
\usage{
plot_peaks(
  df.peaks,
  df.data,
  additional.msecs = 2000,
  plot.to.screen = TRUE,
  path.plots = NULL,
  show.progress = FALSE
)
}
\arguments{
\item{df.peaks}{df.peaks The resulting tibble of the function \code{find_peaks()}. See \code{?find_peaks} for more details.}

\item{df.data}{A data frame or tibble in the below format. The columns \code{t} (time), \code{force} and \code{measurement}
(measurement ID) must be present. This will usually be the same table that was used before in \code{find_peaks()}.}

\item{additional.msecs}{A numeric value indicating how many m.secs before and after the actual peak curve should be plotted. Default: \code{2000}}

\item{plot.to.screen}{A logical value indicating if results should be
plotted in the current R plot device. Default: \code{TRUE}.}

\item{path.plots}{A string character defining where to save the plots. If \code{NULL},
plots will not be saved to PDF files. Default: \code{NULL}}

\item{show.progress}{A logical value indicating if progress should be
printed to the console. Default: \code{FALSE}.}
}
\value{
Plots one graph per peak curve and, if \code{plot.to.pdf == TURE}, saves all peak curves as one PDF at \code{path.plots}.
}
\description{
Plots the peaks identified by the function \code{find_peaks()}.
}
\details{
\code{df.peaks} at least needs to contain the following columns:

\strong{\code{measurements}} |  \strong{\code{starts}} |  \strong{\code{ends}} |
| :----: | :----: |:----: |:----: |
| \code{measurements.1} | \code{starts.1} | \code{ends.1} |
| \code{...} |  \code{...} |  \code{...} |
| \code{measurements.n} | \code{starts.m} | \code{ends.m} |

Check \code{forceR::peaks.df} to see an example tibble.

\code{df.data} at least needs to contain the following columns:\tabular{ccc}{
   \strong{\code{t}} \tab \strong{\code{force}} \tab \strong{\code{measurement}} \cr
   \code{t.1} \tab \code{force.1} \tab \code{measurement.1} \cr
   \code{...} \tab \code{...} \tab \code{...} \cr
   \code{t.n} \tab \code{force.n} \tab \code{measurement.m} \cr
}


Check \code{forceR::df.all.200.tax} to see an example tibble.
}
\examples{
# Using the first row of forceR::peaks.df and the forceR::df.all.200.tax dataset:

# plot peaks
plot_peaks(df.peaks = forceR::peaks.df[1, ],
           df.data = forceR::df.all.200.tax,
           additional.msecs = 20) # instead of the default (2000) because of
                                  # the highly downsampled example dataset.

}
