% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postProcessing.R
\name{shuffle_sim}
\alias{shuffle_sim}
\title{Post-processing to apply changes in temporal structure of annual precipitation.}
\usage{
shuffle_sim(
  sim,
  clim,
  attPerturb = "P_day_all_tot_dwellTime",
  targetVals,
  targetType = "frac",
  seed = 1,
  annAR1coeffList = seq(-0.2, 0.9, 0.01),
  cSel = "mean"
)
}
\arguments{
\item{sim}{a list; simulated climate object from \code{generateScenarios}}

\item{clim}{a list; reference climate}

\item{attPerturb}{a string; name of attribute to be perturbed}

\item{targetVals}{a vector of numbers; targets for perturbed attributes}

\item{targetType}{a vector of strings; type of change in target attributes (either 'frac' or 'diff')}

\item{seed}{an integer; random number seed}

\item{annAR1coeffList}{a vector of numbers; the range of values for annual AR(1) parameters used in grid search}

\item{cSel}{an integer or string; for multi-site data, can either cvalculate perturbed attributes on a single site (integer) or the mean climate over all sites (\code{cSel='mean'}).}
}
\value{
A list with simulated perturbed climates. Same format as output from \code{generateScenarios}.
}
\description{
\code{shuffle_sim} changes the temporal structure of annual climate to match
a target change in a perturbed attribute
}
\examples{
\dontrun{
###############
# load dates, precip, PET and streamflow data for Scott Creek
data('data_A5030502')
# create reference data - won't include PET here since not modelled 
clim_ref = list(times = data_A5030502$times,
                P = data_A5030502$P)  
###############
# create exposure space for baseline climate - no perturbations

attPerturbType = "regGrid"
attPerturb = c('P_day_all_tot_m')
attPerturbSamp = c(1)
attPerturbMin = c(1)
attPerturbMax = c(1)
# will hold a number of attributes to historical values
# note: normP = P99/avg rainfall.  
attHold = c('P_day_all_P99','P_day_all_avgDSD','P_day_all_nWet_m',
            'P_day_DJF_tot_m','P_day_DJF_normP99','P_day_DJF_avgDSD','P_day_DJF_nWet_m',
            'P_day_MAM_tot_m','P_day_MAM_normP99','P_day_MAM_avgDSD','P_day_MAM_nWet_m',
            'P_day_JJA_tot_m','P_day_JJA_normP99','P_day_JJA_avgDSD','P_day_JJA_nWet_m',
            'P_day_SON_tot_m','P_day_SON_normP99','P_day_SON_avgDSD','P_day_SON_nWet_m')
expSpace = createExpSpace(attPerturb = attPerturb,
                          attPerturbSamp = attPerturbSamp,
                          attPerturbMin = attPerturbMin,
                          attPerturbMax = attPerturbMax,
                          attPerturbType = attPerturbType,
                          attHold = attHold)

###############
# setup model settings

modelSelection = list()

modelSelection$modelType = list()
modelSelection$modelType$P = "latent" # latent variable model

modelSelection$modelParameterVariation = list()
modelSelection$modelParameterVariation$P = "seas" # parameters vary with season

modelSelection[["optimisationArguments"]] = list()
modelSelection[["optimisationArguments"]][["OFtol"]] = 0.1 # stop optimization when OF < OFtol

# set penalty weights. More weights to total, and attributes for 'all' data)
modelSelection[["penaltyAttributes"]]=c('P_day_all_tot_m','P_day_all_P99',
                                        'P_day_all_avgDSD','P_day_all_nWet_m')
modelSelection[["penaltyWeights"]] = c(3,2,2,2)

# write to JSON file
modelSelectionJSON = jsonlite::toJSON(modelSelection, pretty = TRUE, auto_unbox = TRUE)
controlFile = paste0(tempdir(), "\\\\eg_controlFile.json")
write(modelSelectionJSON, file = controlFile)

###############
# generate baseline climate scenarios

time.1 = Sys.time()
sim.base = generateScenarios(reference = clim_ref,
                             expSpace = expSpace,
                             controlFile = controlFile,
                             seedID = 1,
                             numReplicates = 1)
time.2 = Sys.time()
print(time.2-time.1)

###############
# shuffle baseline climate to introduce temporal structure at annual scale

sim.shuffle = shuffle_sim(sim=sim.base,
                          clim=clim_ref,
                          attPerturb = 'P_day_all_tot_dwellTime',
                          targetVals = c(1,1.5,2,2.5),
                          targetType = 'frac')

###############
# evaluate how changes in 'P_day_all_tot_dwellTime' affect other attributes

attSel = colnames(sim.base$expSpace$targetMat)
# other attributes
attSel = c(attSel,'P_day_all_tot_dwellTime','P_day_all_avgWSD',
           'P_day_all_P99.9','P_day_JJA_P99.9','P_day_SON_P99.9',
           'P_day_DJF_P99.9','P_day_MAM_P99.9')

att = 'P_day_all_tot_dwellTime'
par(mfrow=c(5,3),mar=c(4,7,2,1))
# plot changes in a single attribute with respect to perturbed attributes
plotPerformanceAttributesOAT(clim=clim_ref,
                             sim=sim.shuffle,
                             attPerturb=att,
                             attEval=attSel,
                             cex.main = 1.5,cex.xaxis = 1,cex.yaxis = 1)  
}
}
