% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csc_metrics.R
\name{csc_metrics}
\alias{csc_metrics}
\title{Cover and sky fraction estimates}
\usage{
csc_metrics(df, filename, transect.length)
}
\arguments{
\item{df}{data frame of uncorrected PCL data}

\item{filename}{name of file currently being processed}

\item{transect.length}{the length of the transect}
}
\value{
slew of cover and sky fraction metrics
}
\description{
\code{csc_metrics} creates first-order canopy structural metrics that
do not require normalization
}
\details{
The \code{csc_metrics} function processes uncorrected PCL data to
generate canopy structural complexity (CSC) metrics that do not
require normalization (i.e. correction for light saturation based on
Beer-Lambert Law). These metrics include:  mean return height of raw data, sd
of raw canopy height returns, maximum measured canopy height, scan density (the
average no. of LiDAR returns per linear meter), and both openness and cover
fraction which are used for gap fraction calcuations.
}
\examples{


csc.metrics <- csc_metrics(pcl_adjusted, filename = "UVA", transect.length = 10)

}
\keyword{complexity}
