% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_title_case.R
\name{str_title_case}
\alias{str_title_case}
\title{Convert string to title case}
\usage{
str_title_case(string)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}
}
\value{
A character vector the same length as the string and in title case.
}
\description{
\code{str_title_case()} converts string to title case, capitalizing only the first letter of each word while ignoring articles, prepositions, and conjunctions
}
\details{
Please note that \code{str_title_case()} is different from \code{\link[stringr:case]{stringr::str_to_title()}} which converts to title case, where only the first letter of each word is capitalized.
}
\examples{

words <- "the quick brown fox jumps over a lazy dog"

str_title_case(words)

str_to_title(words)

words <- "A journey through the history of music"

str_title_case(words)

str_to_title(words)


}
