% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_taxa.R
\name{plot_taxa}
\alias{plot_taxa}
\title{plot_taxa}
\usage{
plot_taxa(
  x,
  taxon,
  trank,
  ranks,
  mode = c("parent", "child", "all"),
  step = NULL
)
}
\arguments{
\item{x}{a dataframe containing hierarchically organised
data in columns}

\item{taxon}{A character vector of element names whose
relationships will be plotted (these must be of the same
rank)}

\item{trank}{A character vector of length one corresponding
to the column name in x in which taxa is located}

\item{ranks}{A character vector corresponding to the column
names in x, given in hierarchical order}

\item{mode}{The direction of the relationships to be
plotted}

\item{step}{A positive integer specifinyg the
neighbourhood of the relationships to plot. Specifying
a number greater than the number of ranks will not cause a
failure, and will instead plot all relationships in the
direction specified in mode}
}
\value{
A plot of the relationships of the specified
elements
}
\description{
Function to plot the parent or child relationships of an
element in a hierarchically organised dataframe. Multiple
taxa can be plotted simultaneously
}
\examples{
# load dataset
data("brachios")
# define ranks in dataset
b_ranks <- c("phylum", "class", "order", "family", "genus")
# plot taxon
plot_taxa(brachios, "Atrypa", trank = "genus", ranks = b_ranks, mode = "parent")
}
