% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpCompare.R
\docType{methods}
\name{\%>=\%}
\alias{\%>=\%}
\alias{\%>>\%}
\alias{\%<=\%}
\alias{\%<<\%}
\alias{\%==\%}
\alias{\%!=\%}
\title{Relational operators with tolerance}
\usage{
x \%>=\% y

x \%>>\% y

x \%<=\% y

x \%<<\% y

x \%==\% y

x \%!=\% y
}
\arguments{
\item{x}{Any numeric object.}

\item{y}{Any numeric object.}
}
\value{
A logical vector indicating the result of the element by element comparison.
        The elements of shorter vectors are recycled as necessary.
}
\description{
Binary operators which allow the comparison of values in numeric vectors.
}
\details{
These are similar to their counterparts in \code{base}, except a tolerance
\code{fpCompare.tolerance} can be specified via \code{options} to account
for floating point rounding errors:

\tabular{cc}{
  \code{fpCompare} \tab \code{base}\cr
  ---------------- \tab -----------\cr
  \code{\%>=\%} \tab \code{>=}\cr
  \code{\%>>\%} \tab \code{>}\cr
  \code{\%<=\%} \tab \code{<=}\cr
  \code{\%<<\%} \tab \code{<}\cr
  \code{\%==\%} \tab \code{==}\cr
  \code{\%!=\%} \tab \code{!=}\cr
}

Inspired by R FAQ 7.31 (\url{https://cran.r-project.org/doc/FAQ/R-FAQ.html#Why-doesn_0027t-R-think-these-numbers-are-equal_003f})
and this post (\url{https://stackoverflow.com/a/2769618/1380598}).
}
\examples{
x1 <- 0.5 - 0.3
x2 <- 0.3 - 0.1
x1 == x2                           # FALSE on most machines
x1 \%==\% x2                         # TRUE everywhere
identical(all.equal(x1, x2), TRUE) # TRUE everywhere

set.seed(123)
a <- 1:6
b <- jitter(1:6, 1e-7)
print(rbind(a, b), digits = 16)

b \%<=\% a
b \%<<\% a
b \%>=\% a
b \%>>\% a
b \%==\% a
b \%!=\% a
}
\seealso{
\code{\link{all.equal}}, \code{\link{.Machine}}
}
\author{
Alex Chubaty
}
