% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fracdist.R
\name{fracdist_values}
\alias{fracdist_values}
\title{Calculate Critical Values or P-values for Fractional Unit Root and Cointegration Tests}
\usage{
fracdist_values(
  iq,
  iscon,
  dir_name = NULL,
  bb,
  stat,
  ipc = TRUE,
  clevel = c(0.01, 0.05, 0.1)
)
}
\arguments{
\item{iq}{An integer scalar rank parameter for the test, from 1 through 12.
This is often the difference in cointegration rank.}

\item{iscon}{An indicator that there is a constant intercept
term in the model.}

\item{dir_name}{A string name of directory in which the approximating tables
are stored. This is not normally used, since sufficient tables are included in the package.
However, a user might want to draw the tables from another location.}

\item{bb}{The fractional integration parameter, which can take on values
between 0.0 and 2.0.}

\item{stat}{A numeric scalar value of the test statistic. This is only
used if P-values are required.}

\item{ipc}{A logical indicator to calculate a P-value.
If \code{ipc == FALSE} critical values are calculated instead.}

\item{clevel}{The numeric scalar level of significance. The default is to
calculate critical values for the conventional levels of significance:
\code{clevel = c(0.01, 0.05, 0.10)}.}
}
\value{
Either a numeric scalar P-value, if \code{ipc == TRUE},
otherwise, a numeric vector of critical values, the same length as \code{clevel}.
}
\description{
\code{fracdist_values} calculates either critical Values or P-values for
for fractional unit root and cointegration tests
}
\note{
For fractional integration orders between 0 and 0.5, the chi-square
distribution is used. See Johansen and Nielsen 2012 for details.
}
\examples{
# Calculate P-values:
fracdist_values(iq = 1, iscon = 0, bb = 0.43, stat = 3.84)
fracdist_values(iq = 1, iscon = 0, bb = 0.73, stat = 3.84)
# Calculate critical values:
fracdist_values(iq = 1, iscon = 0, bb = 0.73, ipc = FALSE, clevel = 0.05)
fracdist_values(iq = 1, iscon = 0, bb = 0.43, ipc = FALSE, clevel = 0.05)
fracdist_values(iq = 1, iscon = 0, bb = 0.73, ipc = FALSE)
}
\references{
James G. MacKinnon and Morten \enc{Ø}{O}rregaard Nielsen,
"Numerical Distribution Functions of Fractional Unit Root and Cointegration Tests,"
\emph{Journal of Applied Econometrics}, Vol. 29, No. 1, 2014, pp.161-171.

Johansen, S. and M. \enc{Ø}{O}. Nielsen (2012).
"Likelihood inference for a fractionally cointegrated vector autoregressive model,"
\emph{Econometrica} 80, pp.2667-2732.
}
\seealso{
Calls \code{fpval} to calculate P-values
or \code{fpcrit} to calculate critical values,
after performing some intermediate calculations.
}
