% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Estep}
\alias{Estep}
\title{Perform the E step calculations}
\usage{
Estep(c, c_lt, delta, alpha, bbeta, pvfm, dist)
}
\arguments{
\item{c}{Vector of length \code{K} of cumulative hazards, i.e. total accumulated hazards within a cluster}

\item{c_lt}{Vector of length \code{K} of cumulative hazard from 0 to the left truncation time}

\item{delta}{Vector of integers of length \code{K} of the number of events for each cluster}

\item{alpha, bbeta}{Parameters of the frailty distribution}

\item{pvfm}{Parameter for the PVF distribution, only matters in that case}

\item{dist}{One of 0 (for gamma), 1 (for stable) or 2 (for PVF)}
}
\value{
A \code{K x 3} matrix where the first column and the second column are the numerators
and the denominators of the frailty fraction (without the Laplace transform) and the
last column is the log(denominator) + log-Laplace transform, i.e. the log-likelihood contribution
}
\description{
This is an inner wrapper for the C++ functions which perform the E step and is not intended to be used directly.
This function does not check the input.
For a data set with \code{K} clusters,
}
\keyword{internal}
