% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_freqpcr.R
\name{.freqpcr_loglike_cont}
\alias{.freqpcr_loglike_cont}
\title{Log-likelihood when sample allele ratio is continuous.}
\usage{
.freqpcr_loglike_cont(
  X,
  A,
  DCW,
  DCD,
  zeroAmount,
  para.fixed = NULL,
  beta = TRUE,
  dummyDCW = FALSE
)
}
\arguments{
\item{X}{Numeric vector that stores the parameter values to be optimized via \code{\link{nlm}()}: \code{P} in logit scale and \code{K}, \code{targetScale}, \code{sdMeasure}, and \code{EPCR} in log scale.}

\item{A}{Relative DNA content between the samples. A continuous version of \code{N} in \code{\link{.freqpcr_loglike}()}, as a numeric vector.}

\item{DCW, DCD}{Numeric vectors. They store the measured values of the two \eqn{\Delta}Cq: \code{DCW (= target0 - housek0)} and \code{DCD (= target1 - housek1)}.}

\item{zeroAmount}{(In RED-\eqn{\Delta\Delta}Cq method) residue rate of restriction enzyme digestion, or (in general \eqn{\Delta\Delta}Cq analyses) small portion of the off-target allele on the target locus of the test sample, which will be amplified in the PCR. It needs to be always specified by the user as a number between 0 and 1, usually near 0.}

\item{para.fixed}{Named numeric vector that stores the fixed parameters inherited from \code{\link{freqpcr}()}, if specified. By default (\code{NULL}), all the parameters (\code{P}, \code{K}, \code{targetScale}, \code{sdMeasure}, and \code{EPCR}) are unknown. Unlike \code{X}, each element value is set in linear scale.}

\item{beta}{Whether to use the beta distribution to approximate the sample allele ratio instead of specifying individual gamma distribution for each of the allelic DNA amounts? Default is \code{TRUE}, which accelerates the calculation.}

\item{dummyDCW}{Whether the \eqn{\Delta}Cq values of the control samples are dummy or not.}
}
\value{
Scalar of the log likelihood.
}
\description{
Called from \code{\link{freqpcr}()} instead of \code{\link{.freqpcr_loglike}()} when the model is `continuous'. This function assumes that each sample does not consist of \code{n} individual organisms with certain genotypes, but the result of a direct DNA extraction from the sub-population having the allele ratio around \code{p:(1-p)}. Each sample allele ratio is considered to follow \code{Beta(apk, a(1-p)k)}, where \code{a} and \code{k} are the relative DNA content of the sample and the gamma shape parameter, respectively.
}
