% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number-friendly.R
\name{number_friendly}
\alias{number_friendly}
\alias{number_friendly.numeric}
\alias{number_friendly.integer}
\alias{number_friendly.bignum_biginteger}
\alias{number_friendly.bignum_bigfloat}
\alias{number_friendly.default}
\alias{number_friendly_safe}
\alias{number_friendly_safe.numeric}
\alias{number_friendly_safe.integer}
\alias{number_friendly_safe.bignum_biginteger}
\alias{number_friendly_safe.bignum_bigfloat}
\alias{number_friendly_safe.default}
\title{Translate a vector of numbers to a cardinal character vector}
\usage{
number_friendly(numbers, ...)

\method{number_friendly}{numeric}(
  numbers,
  zero = "zero",
  na = "missing",
  nan = "not a number",
  inf = "infinity",
  negative = "negative ",
  decimal = " and ",
  and = FALSE,
  hyphenate = TRUE,
  and_fractional = and,
  hyphenate_fractional = hyphenate,
  english_fractions = NULL,
  ...
)

\method{number_friendly}{integer}(
  numbers,
  zero = "zero",
  na = "missing",
  nan = "not a number",
  inf = "infinity",
  negative = "negative ",
  and = FALSE,
  hyphenate = TRUE,
  ...
)

\method{number_friendly}{bignum_biginteger}(
  numbers,
  zero = "zero",
  na = "missing",
  nan = "not a number",
  inf = "infinity",
  negative = "negative ",
  and = FALSE,
  hyphenate = TRUE,
  ...
)

\method{number_friendly}{bignum_bigfloat}(
  numbers,
  zero = "zero",
  na = "missing",
  nan = "not a number",
  inf = "infinity",
  negative = "negative ",
  decimal = " and ",
  and = FALSE,
  hyphenate = TRUE,
  and_fractional = and,
  hyphenate_fractional = hyphenate,
  english_fractions = NULL,
  ...
)

\method{number_friendly}{default}(numbers, ...)

number_friendly_safe(numbers, ...)

\method{number_friendly_safe}{numeric}(
  numbers,
  zero = "zero",
  na = "missing",
  nan = "not a number",
  inf = "infinity",
  negative = "negative ",
  decimal = " and ",
  and = FALSE,
  hyphenate = TRUE,
  and_fractional = and,
  hyphenate_fractional = hyphenate,
  english_fractions = NULL,
  ...
)

\method{number_friendly_safe}{integer}(
  numbers,
  zero = "zero",
  na = "missing",
  nan = "not a number",
  inf = "infinity",
  negative = "negative ",
  and = FALSE,
  hyphenate = TRUE,
  ...
)

\method{number_friendly_safe}{bignum_biginteger}(
  numbers,
  zero = "zero",
  na = "missing",
  nan = "not a number",
  inf = "infinity",
  negative = "negative ",
  and = FALSE,
  hyphenate = TRUE,
  ...
)

\method{number_friendly_safe}{bignum_bigfloat}(
  numbers,
  zero = "zero",
  na = "missing",
  nan = "not a number",
  inf = "infinity",
  negative = "negative ",
  decimal = " and ",
  and = FALSE,
  hyphenate = TRUE,
  and_fractional = and,
  hyphenate_fractional = hyphenate,
  english_fractions = NULL,
  ...
)

\method{number_friendly_safe}{default}(numbers, ...)
}
\arguments{
\item{numbers}{A vector of numbers to translate. The friendlynumber package defines
methods for integer, numeric, \code{\link[bignum:biginteger]{bignum::biginteger()}}, and
\code{\link[bignum:bigfloat]{bignum::bigfloat()}} numbers.
\itemize{
\item Integers are passed to \code{\link[=integerish_friendly]{integerish_friendly()}}
\item Numeric vectors are passed to \code{\link[=numeric_friendly]{numeric_friendly()}}
\item \code{\link[bignum:biginteger]{bignum::biginteger()}} vectors are passed to \code{\link[=biginteger_friendly]{biginteger_friendly()}}
\item \code{\link[bignum:bigfloat]{bignum::bigfloat()}} vectors are passed to \code{\link[=bigfloat_friendly]{bigfloat_friendly()}}
}}

\item{...}{Additional arguments passed to or from other methods.}

\item{zero}{\verb{[character(1)]}

What to call values of \code{0} in \code{numbers} (e.g. \code{zero = "zero"}).}

\item{na}{\verb{[character(1)]}

What to call values of \code{NA} in \code{numbers} (e.g. \code{na = "missing"}).}

\item{nan}{\verb{[character(1)]}

What to call values of \code{NaN} in \code{numbers} (e.g. \code{nan = "undefined"}).}

\item{inf}{\verb{[character(1)]}

What to call values of \code{Inf} in \code{numbers} (e.g. \code{inf = "infinity"}).}

\item{negative}{\verb{[character(1)]}

A prefix added to the translation of negative elements of \code{numbers}.
\code{negative} is the string \code{"negative "} by default.}

\item{decimal}{\verb{[character(1)]}

A word inserted between the whole and fractional part of translated
\code{numbers}. \code{decimal} is the string \code{" and "} by default.}

\item{and}{\verb{[TRUE / FALSE]}

Whether to insert an \code{" and "} before the tens place of translated \code{numbers}.
\code{and} is \code{FALSE} by default.}

\item{hyphenate}{\verb{[TRUE / FALSE]}

Whether to hyphenate numbers 21 through 99 (e.g. \code{"twenty-one"} vs. \code{"twenty one"}).
\code{hyphenate} is \code{TRUE} by default.}

\item{and_fractional}{\verb{[TRUE / FALSE]}

Whether to insert an \code{" and "} before the smallest fractional tens place
of translated \code{numbers} (e.g. \code{"one hundred one thousandths"} vs.
\code{"one hundred and one thousandths"}).

\code{and_fractional} is equal to \code{and} by default.}

\item{hyphenate_fractional}{\verb{[TRUE / FALSE]}

Whether to hyphenate numbers 21 through 99 in the fractional part of translated
\code{numbers} (e.g. \code{"twenty-one hundredths"} or \code{"twenty one hundredths"}). This
also determines the hyphenation of the fractional units (e.g. \code{"one ten-millionth"}
vs. \code{"one ten millionth"}).

\code{hyphenate_fractional} is equal to \code{hyphenate} by default.}

\item{english_fractions}{\verb{[character]}

A named character vector used as a dictionary for the translation of the
fractional part of \code{numbers}. The names (i.e. keys) are the decimal digits
of a fractional number and the values are the corresponding translations.

For example \code{english_fractions = c("5" = "a half")} matches the number
\code{0.5} (translated as \code{"a half"}) and \code{2.5} (translated as \code{"two and a half"}).

By default \code{english_fractions} is a named character vector with translations
for fractions \code{x / y} for \verb{x = 1, 2, ..., 8} and \verb{y = 1, 2, ..., 9}. For
example, \code{2 / 3} is translated as \code{"two thirds"} and \code{1 / 2} is translated
as \code{"one half"}.

Provide an empty character to \code{english_fractions} to opt out of any such
translations. In this case \code{1 / 2} is translated as \code{"five tenths"} instead
of \code{"one half"}.}
}
\value{
A non-NA character vector of the same length as \code{numbers}.
}
\description{
Convert a vector of numbers to a cardinal numeral (e.g. one tenth, one, two).

\code{number_friendly_safe()} checks that all arguments are of the correct type
and raises an informative error otherwise. \code{number_friendly()} does not
perform input validation to maximize its speed.
}
\examples{
number_friendly(c(1/3, 0, 0.999, NA, NaN, Inf, -Inf))
number_friendly(c(1L, 2L, 1001L))

# Input validation
try(number_friendly_safe(1L, zero = c("a", "zero")))
}
\seealso{
\code{\link[=integerish_friendly]{integerish_friendly()}}, \code{\link[=numeric_friendly]{numeric_friendly()}},
\code{\link[=biginteger_friendly]{biginteger_friendly()}}, \code{\link[=bigfloat_friendly]{bigfloat_friendly()}}
}
