% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_elements.R
\name{get_elements}
\alias{get_elements}
\title{Get metadata about the weather and climate elements that are
defined in the Frost API}
\usage{
get_elements(client_id,
             ids = NULL,
             names = NULL,
             descriptions = NULL,
             units = NULL,
             code_tables= NULL,
             statuses = NULL,
             calculation_method = NULL,
             categories = NULL,
             time_offsets = NULL,
             sensor_levels = NULL,
             old_element_codes = NULL,
             old_units = NULL,
             cf_standard_names = NULL,
             cf_cell_methods = NULL,
             cf_units = NULL,
             cf_versions = NULL,
             fields = NULL,
             language = NULL,
             return_response = FALSE)
}
\arguments{
\item{client_id}{A string. The client ID to use to send requests to the
Frost API.}

\item{ids}{A character vector. The element IDs to get metadata for.}

\item{names}{A character vector. The element names to get metadata for.}

\item{descriptions}{A character vector. The descriptions to get metadata
for.}

\item{units}{A character vector. The units to get metadata for.}

\item{code_tables}{A character vector. The code tables to get metadata for.}

\item{statuses}{A character vector. The statuses to get metadata for.}

\item{calculation_method}{A string. The calculation method as a JSON filter.
Supports the following keys: baseNames, methods, innerMethods, periods,
innerPeriods, thresholds, methodDescriptions, innerMethodDescriptions,
methodUnits, and innerMethodUnits.}

\item{categories}{A character vector. The categories to get metadata for.}

\item{time_offsets}{A character vector. The time offsets to get metadata for.}

\item{sensor_levels}{A string. The sensor levels to get metadata
for as a JSON filter. Supports the following keys: levelTypes, units,
defaultValues, and values.}

\item{old_element_codes}{A character vector. The old MET Norway element codes
to get metadata for.}

\item{old_units}{A character vector. The old MET Norway units to get
metadata for.}

\item{cf_standard_names}{A character vector. The CF standard names to get
metadata for.}

\item{cf_cell_methods}{A character vector. The CF cell methods to get
metadata for.}

\item{cf_units}{A character vector. The CF units to get metadata for.}

\item{cf_versions}{A character vector. The CF versions to get metadata for.}

\item{fields}{A character vector. Fields to include in the response (i.e.
output). If this parameter is specified, then only these fields are
returned in the response. If not specified, then all fields will be
returned in the response.}

\item{language}{A string. The language of the fields in the response. The
options are "en-US" (default), "nb-NO" (Norwegian, Bokmål), and "nn-NO"
(Norwegian, Nynorsk).}

\item{return_response}{A logical. If set to \code{TRUE}, then the function
returns the response from the GET request. If set to \code{FALSE} (default),
then the function returns a tibble (data frame) of the content in the
response.}
}
\value{
The function returns either a data frame with metadata about
climate and weather elements, or the response of the GET request, depending
on the boolean value set for \code{return_response}.
}
\description{
\code{get_elements()} retrieves metadata about weather and
climate elements defined for use in the Frost API. The function requires an
input for \code{client_id}. The other function arguments are optional, and
default to \code{NULL}, which means that the response from the API is not
filtered on these parameters.
}
\examples{
\dontrun{
frost_client_id <- "<YOUR FROST CLIENT ID>"

# Get data for all elements
elements_df <- get_elements(client_id = frost_client_id)
}

}
