% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FstBattia.R
\name{BuildFreqNbG}
\alias{BuildFreqNbG}
\title{Convert the Freq and NbGamete tables into a list.}
\usage{
BuildFreqNbG(Freq, NbGamete)
}
\arguments{
\item{Freq}{A data.frame or matrix of frequencies where each row corresponds to a marker, each column corresponds to a population,}

\item{NbGamete}{A data.frame or matrix of number of gametes where each row corresponds to a marker, and each column corresponds to a population}
}
\value{
a list of data.frames, each corresponding to a population.
}
\description{
The function builds a list where each element corresponds to a population present in both Freq and NbGametes (all other
populations being discarded). Each element consists of a data.frame with 2 columns, Freq and NbGamete.
}
\examples{
## Load the HGDP data 
data(Freq);data(NbGamete)
FreqNbG <- BuildFreqNbG(Freq,NbGamete)
}
