% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FstBattia.R
\name{ContrastSummary}
\alias{ContrastSummary}
\title{ContrastSummary}
\usage{
ContrastSummary(PS, RefLevel, Ratio.thres = 3, NbSnp.min = 1)
}
\arguments{
\item{PS}{a list of profile summaries, as provided by the \code{ProfilingSummary} function}

\item{RefLevel}{a list of reference (i.e. baseline) Fst levels}

\item{Ratio.thres}{a numeric value, regions exhibiting Fst levels whose ratio with the reference level is 
higher than Ratio.thres will be highlighted.}

\item{NbSnp.min}{an integer. The minimum number of markers required to highlight a region}
}
\value{
a tibble
}
\description{
Summarize multiple Fst profiles
}
\examples{
## The full example execution takes a few seconds.
# data(Freq);data(NbGamete)
# FreqNbG <- BuildFreqNbG(Freq,NbGamete)
# HFst.m <- HudsonFst.m(FreqNbG)

## Two sets of populations to contrast
# Contrast <- list(America=c("Colombian","Maya"),Europe=c("Tuscan","Italian"))
# Profiles <- HudsonFst.prof(HFst.m,Contrast=Contrast)
# PS <- ProfilingSummary(Profiles,Info) 

# RefLevel <- rapply(Profiles,median,classes = "numeric",how='list')
# Ratio.thres <- 3
# NbSnp.min <- 1
# CS <- ContrastSummary(PS, RefLevel,
#                       Ratio.thres=Ratio.thres,
#                       NbSnp.min=NbSnp.min)
}
