% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graphs.R
\name{HudsonFst.plot}
\alias{HudsonFst.plot}
\title{Plot Fst values along chromosomes}
\usage{
HudsonFst.plot(
  Info,
  HFst.m,
  HFst.prof = NULL,
  Coord = NULL,
  Ref = NULL,
  Threshold = NULL
)
}
\arguments{
\item{Info}{a data.frame providing information about markers}

\item{HFst.m}{a data.frame with 2 columns, Fst and Weight, as provided by the \code{HudsonFst.m} function}

\item{HFst.prof}{a data.frame corresponding to one item of the output of the \code{HudsonFst.prof} function}

\item{Coord}{a vector with the minimum and maximum coordinates (i.e. positions along the genome)
providing the range of the genomic region that will be plotted.}

\item{Ref}{a value to plot a reference line}

\item{Threshold}{a value to plot a threshold line}
}
\value{
a ggplot object
}
\description{
Plot Fst values along chromosomes
}
\examples{
## The full example execution takes a few seconds.
data(Freq);data(NbGamete)
FreqNbG <- BuildFreqNbG(Freq,NbGamete)
HFst.m <- HudsonFst.m(FreqNbG)
TwoPops <- list(First="Colombian",Second="Tuscan")
HFst.prof <- HudsonFst.prof(HFst.m,Contrast=TwoPops)

## Plot the raw data
\donttest{
HudsonFst.plot(Info,HFst.m$Colombian_Tuscan)
}
## Plot the raw data and the segmentation
\donttest{
HudsonFst.plot(Info,HFst.m$Colombian_Tuscan,HFst.prof$Colombian_Tuscan)
}
## Add a background/reference level
\donttest{
RefLevel <- median(HFst.prof$Colombian_Tuscan)
HudsonFst.plot(Info,HFst.m$Colombian_Tuscan,HFst.prof$Colombian_Tuscan,
               Ref=RefLevel)
}
## Add a threshold 
\donttest{
Threshold <- 3*RefLevel
HudsonFst.plot(Info,HFst.m$Colombian_Tuscan,HFst.prof$Colombian_Tuscan,
               Ref=RefLevel,Threshold = Threshold)
}
}
