% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FstBattia.R
\name{HudsonFst.prof}
\alias{HudsonFst.prof}
\title{HudsonFst.prof}
\usage{
HudsonFst.prof(
  HFst.m,
  Contrast = NULL,
  Kmax = 100,
  NbSegCrit = "biggest.S3IB",
  parallel = TRUE
)
}
\arguments{
\item{HFst.m}{A list of data.frame with two columns each, Fst and Weight, 
as provided by the \code{HudsonFst.m} function}

\item{Contrast}{a list of two vectors with the names of the populations to be contrasted}

\item{Kmax}{maximum number of breakpoints to be considered}

\item{NbSegCrit}{the criterion used for the choice of the number of segments}

\item{parallel}{a boolean, should the profiling be parallelized (using future) or not}
}
\value{
a smoothed profile
}
\description{
Perform FST profiling between pairs of pops, as requested by Contrast. If no contrast is provided, all pairs are considered
}
\examples{
data(Freq);data(NbGamete)
FreqNbG <- BuildFreqNbG(Freq,NbGamete)
HFst.m <- HudsonFst.m(FreqNbG)

## Two population analysis
TwoPops <- list(First="Colombian",Second="Tuscan")
HFst.prof <- HudsonFst.prof(HFst.m,Contrast=TwoPops)

## The full example execution takes a few seconds.
## Two sets of populations to contrast
\donttest{
Contrast <- list(America=c("Colombian","Maya"),Europe=c("Tuscan","Italian"))
Profiles <- HudsonFst.prof(HFst.m,Contrast=Contrast)
}
## For larger lists and/or larger marker sets, 
## use the future package for parallel computation:
\donttest{
future::plan("multisession",workers=4)
Profiles <- HudsonFst.prof(HFst.m,Contrast=Contrast)
future::plan("default")
}
}
