% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazard.R
\name{hazard}
\alias{hazard}
\title{Hazard Rate Function}
\usage{
hazard(t, D, P, ...)
}
\arguments{
\item{t}{a numeric value as time}

\item{D}{a density function}

\item{P}{a cumulative density function}

\item{...}{More parameters}
}
\value{
A numeric vector of hazard rate values.
}
\description{
For a given vector of times and a probability distribution function,
this function calculates the hazard rate values.
}
\details{
Hazard rate functions defined as the ratio of the density
function and the survival function. That is:
}
\examples{
## Standard normal distribution
t <- c(0.1, 0.01)
P <- pnorm
D <- dnorm
hazard(t, D, P)

## Uniform distribution with min=2.0 and max=2.5
t <- 2.2
P <- punif
D <- dunif
hazard(t, D, P, 2.0, 2.5)
}
