% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kNUComposition_DNA.R
\name{kNUComposition_DNA}
\alias{kNUComposition_DNA}
\title{k Nucleotide Composition (kNUComposition_DNA)}
\usage{
kNUComposition_DNA(
  seqs,
  rng = 3,
  reverse = FALSE,
  upto = FALSE,
  normalized = TRUE,
  ORF = FALSE,
  reverseORF = TRUE,
  label = c()
)
}
\arguments{
\item{seqs}{is a FASTA file containing nucleotide sequences. The sequences start
with '>'. Also, seqs could be a string vector. Each element of the vector is a nucleotide sequence.}

\item{rng}{This parameter can be a number or a vector. Each entry of the vector holds the value of k in the k-mer composition.
For each k in the rng vector, a new vector (whose size is 4^k) is created which contains the frequency of kmers.}

\item{reverse}{It is a logical parameter which assumes the reverse complement of the sequence.}

\item{upto}{It is a logical parameter. The default value is FALSE. If rng is a number and upto is set to TRUE, rng is converted
to a vector with values from 1 to rng.}

\item{normalized}{is a logical parameter. When it is FALSE, the return value of the function does not change. Otherwise, the return value is normalized using the length of the sequence.}

\item{ORF}{(Open Reading Frame) is a logical parameter. If it is set to true, ORF region of each sequence is considered instead of the original sequence (i.e., 3-frame).}

\item{reverseORF}{is a logical parameter. It is enabled only if ORF is true.
If reverseORF is true, ORF region will be searched in the sequence and also in the reverse complement of the sequence (i.e., 6-frame).}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix. The number of rows is equal to the number of sequences and
the number of columns depends on the rng vector. For each value k in the vector, (4)^k columns are created in the matrix.
}
\description{
This function calculates the frequency of all k-mers in the sequence.
}
\examples{

fileLNC<-system.file("extdata/Athaliana_LNCRNA.fa",package="ftrCOOL")
mat<-kNUComposition_DNA(seqs=fileLNC,rng=c(1,3))

}
