% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simu_data.R
\name{response_simu}
\alias{response_simu}
\title{Simulate witness responses}
\usage{
response_simu(
  guilt_diff,
  inno_diff = 0,
  n_sim = 1000,
  size = 6,
  inno_suspect = FALSE,
  criterion,
  id_criterion = NULL
)
}
\arguments{
\item{guilt_diff}{Mean difference between guilty suspect and filler distributions.}

\item{inno_diff}{Mean difference between innocent suspect and filler distributions. Defaults to 0.}

\item{n_sim}{Number of simulations per condition. Defaults to 1,000.}

\item{size}{Number of lineup members. Defaults to 6.}

\item{inno_suspect}{Whether there is a designated innocent suspect. Defaults to FALSE.}

\item{criterion}{A vector of response criteria. Must have odd number of elements if id_criterion is not specified.}

\item{id_criterion}{A number to define the criterion for id or rejection. Use the middle element of criterion if not specified.}
}
\value{
A data frame including both CP and CA ID responses and confidence levels.
}
\description{
A function to simulate both CP and CA responses
}
\examples{
## Set up response criteria
rc1 <- seq(-1, 3, length.out = 5)

## no designated innocent suspect
response_simu(guilt_diff = 2, criterion = rc1)

## with a designated innocent suspect
response_simu(guilt_diff = 2, inno_diff = 0.2, inno_suspect = TRUE, criterion = rc1)

## define a criterion for id/rejection instead of using the middle criterion
response_simu(guilt_diff = 2, criterion = 0:3, id_criterion = 1)
}
