% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_column_names.R
\name{validate_column_names}
\alias{validate_column_names}
\title{Validate Column Names}
\usage{
validate_column_names(names)
}
\arguments{
\item{names}{A character vector of column names to validate.}
}
\value{
Returns \code{TRUE} if all checks pass. If any check fails, the function stops and returns an error message.
}
\description{
This function checks a vector of column names to ensure they are valid. It performs the following checks:
\itemize{
\item The column names must not be \code{NULL}.
\item The column names must not contain empty strings.
\item The column names must not contain \code{NA} values.
\item The column names must be unique.
}
}
\examples{
validate_column_names(c("name", "age", "gender"))

}
