% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_set.R
\name{argvals}
\alias{argvals}
\alias{getArgvals}
\alias{getArgvals,funData-method}
\alias{getArgvals,multiFunData-method}
\alias{getArgvals,irregFunData-method}
\alias{X}
\alias{getX}
\alias{getX,funData-method}
\alias{getX,multiFunData-method}
\alias{getX,irregFunData-method}
\alias{argvals<-}
\alias{setArgvals}
\alias{setArgvals,funData-method}
\alias{setArgvals,multiFunData-method}
\alias{setArgvals,irregFunData-method}
\alias{X<-}
\alias{setX}
\alias{setX,funData-method}
\alias{setX,multiFunData-method}
\alias{setX,irregFunData-method}
\title{Extract and set slots from functional data objects}
\usage{
argvals(object)

getArgvals(object)

\S4method{getArgvals}{funData}(object)

\S4method{getArgvals}{multiFunData}(object)

\S4method{getArgvals}{irregFunData}(object)

X(object)

getX(object)

\S4method{getX}{funData}(object)

\S4method{getX}{multiFunData}(object)

\S4method{getX}{irregFunData}(object)

argvals(object) <- value

setArgvals(object, value)

\S4method{setArgvals}{funData}(object, value)

\S4method{setArgvals}{multiFunData}(object, value)

\S4method{setArgvals}{irregFunData}(object, value)

X(object) <- value

setX(object, value)

\S4method{setX}{funData}(object, value)

\S4method{setX}{multiFunData}(object, value)

\S4method{setX}{irregFunData}(object, value)
}
\arguments{
\item{object}{An object of class \code{funData}, \code{irregFunData} or
\code{multiFunData}.}

\item{value}{New \code{argvals} or \code{X}. See Details.}
}
\value{
See Details.
}
\description{
These functions can be used to extract and set the slots of
\code{funData}, \code{irregFunData} and \code{multiFunData} objects.
}
\details{
Objects of class \code{funData} or \code{irregFunData} have two slots,
\code{argvals} (for the x-values) and \code{X} (for the y-values for
each observation). Using the \code{argvals} (alias: \code{getArgvals})
and \code{X} (alias: \code{getX}) methods for the classes
\code{funData} and \code{irregFunData} is equivalent to accessing the
slots directly via \code{object@argvals} and \code{object@X}.
Analogously, the \code{argvals<-} and \code{X<-} functions are
equivalent to setting \code{object@argvals} to \code{value} or
\code{object@X} to \code{value}, respectively. The new values must
hence have the same structure as the original ones. As an exception,
for an object of class \code{funData} the number of new X values may
differ from the current (e.g. when adding new observations). In this
case, the function throws a warning.

Objects of class \code{multiFunData} are lists of several
\code{funData} objects. The functions \code{argvals} and \code{X} for
\code{multiFunData} objects therefore return a list of the same length
as \code{object}, where each list element corresponds to the
\code{argvals} or \code{X} slot of the univariate element. The
\code{argvals<-} and \code{X<-} functions for \code{multiFunData}
objects must receive lists of the same length as \code{object}, where
each list element corresponds to the new \code{argvals} or new \code{X}
slot for the univariate elements.
}
\section{Warning}{
 The functions \code{getArgvals} / \code{getX} and
  \code{setArgvals} / \code{setX} from former package versions are
  deprecated. use \code{argvals} and \code{X} instead.
}

\examples{
### Univariate
object <- funData(argvals = 1:5, X = rbind(1:5, 6:10))
object

# get-methods
argvals(object)
X(object)

# set-methods
argvals(object) <- 0:4
object 
\dontrun{argvals(object) <- 1:4} # wrong length
X(object) <- rbind(0:4, 5:9)
\dontrun{X(object) <- rbind(0:4, 5:9, 10:14) # warning: now 3 observations (was 2 before)}
\dontrun{X(object) <- rbind(1:4, 5:8)} # wrong length

### Univariate (irregular)
irregObject <- irregFunData(argvals = list(1:5, 2:4), X = list(2:6, 3:5))
irregObject

# get-methods
argvals(irregObject)
X(irregObject)

# set-methods
argvals(irregObject) <- list(0:4, 1:3)
X(irregObject) <- list(12:16, 13:15)

### Multivariate
multiObject <- multiFunData(object, funData(argvals = 1:3, X = rbind(3:5, 6:8)))
multiObject

# get-methods
argvals(multiObject)
X(multiObject)

# set-methods (for special cases see univariate version)
argvals(multiObject) <- list(5:1, 3:1)
X(multiObject) <- list(rbind(5:1, 10:6), rbind(5:3, 8:6))
}
\seealso{
\code{\linkS4class{funData}},
  \code{\linkS4class{irregFunData}}, \code{\linkS4class{multiFunData}}
}
\keyword{internal}
