% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/floop.R
\name{floop}
\alias{floop}
\title{Functional loop with optional parallelism and progress bar}
\usage{
floop(.x, .f, ncores = 1, pb = FALSE, .capture = TRUE, ...)
}
\arguments{
\item{.x}{A vector or list of elements to iterate over.}

\item{.f}{A function to apply to each element of `.x`.}

\item{ncores}{Integer. Number of cores to use. Default is 1 (sequential).}

\item{pb}{Logical. Show a progress bar? Default is `FALSE`.}

\item{.capture}{Logical. Should results of `.f` be captured and returned? If `FALSE`, acts like a side-effect loop.}

\item{...}{Additional arguments passed to `.f`.}
}
\value{
A list of results if `.capture = TRUE`, otherwise returns `.x` invisibly.
}
\description{
`floop()` applies a function `.f` to each element of `.x`, optionally in parallel, and with an optional progress bar.
Unlike `fwalk()`, it can return results or be used purely for side effects (like a for-loop).
}
\examples{
# Functional loop that collects output
floop(1:3, function(i) i^2)

# Side-effect only loop (like for-loop with cat)
\donttest{
floop(1:5, function(i) cat(" Processing", i, "\n"), pb = TRUE, .capture = FALSE)
}

}
