% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmap.R
\name{fmap}
\alias{fmap}
\title{Functional mapping with optional parallelism and progress bars}
\usage{
fmap(.x, .f, ncores = NULL, pb = FALSE, ...)
}
\arguments{
\item{.x}{A list or atomic vector of elements to iterate over.}

\item{.f}{A function to apply to each element of `.x`. Can be a function or a string naming a function.}

\item{ncores}{Integer. Number of CPU cores to use for parallel processing. Default is `NULL` (sequential).}

\item{pb}{Logical. Whether to show a progress bar. Default is `FALSE`.}

\item{...}{Additional arguments passed to `.f`.}
}
\value{
A list of results, one for each element of `.x`.
}
\description{
Applies a function `.f` to each element of `.x`, with optional parallel processing and progress bar support.
}
\examples{
slow_fn <- function(x) { Sys.sleep(0.01); x^2 }
x <- 1:100

# Basic usage
fmap(x, slow_fn)

# With progress bar
fmap(x, slow_fn, pb = TRUE)

# With parallel execution (non-Windows)
\donttest{
if (.Platform$OS.type != "windows") {
  fmap(x, slow_fn, ncores = 2, pb = TRUE)
}
}

}
