% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifyData.R
\name{getCountData}
\alias{getCountData}
\title{Get Agent Count Data}
\usage{
getCountData(
  agent_data,
  outcome,
  unit,
  replicate = NULL,
  type = "type",
  data_append = NULL
)
}
\arguments{
\item{agent_data}{Data.frame of agent data information, with columns as
defined in subsequent parameters}

\item{outcome}{String of the column name in data indicating the outcome or
response.}

\item{unit}{String of the column name in data indicating a unit or
base thing. Note this unit may have replicates.}

\item{replicate}{(Optional) String of the column name in data indicating the
replicate id. Default is NULL.}

\item{type}{(Optional) String of the column name in data indicating the
type. Default is type.}

\item{data_append}{(Optional) Data.frame with outcome, patient that the
results can be appended to if desired. Default is NULL.}
}
\value{
List with two elements:
\itemize{
\item dat: Data.frame with outcome, unit, data_append, and the count
data. Columns of the count data are named after the type and are given
in the next list entry.
\item agents: Vector of the the types, i.e. the column names for the
new count data. This can be treated as meta data for funkyForest.
}
}
\description{
This function gets the average percent agent counts per replicate, if there
are replicates (i.e. replicate is not NULL), then the agent percents are
calculated for each replicate and these percentages are averaged.
}
\examples{
data_ct <- getCountData(TNBC_pheno[TNBC_pheno$Phenotype \%in\% c('Tumor','B'),],
                        outcome="Class", unit="Person",type="Phenotype")
}
