% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MarginalCor.r
\name{marginal.cor}
\alias{marginal.cor}
\title{Calculate marginal correlations with response}
\usage{
marginal.cor(object, id = NULL, response = NULL, alpha = 0.05)
}
\arguments{
\item{object}{An object of type \code{funeigen} or \code{funreg}.  One or the other of these is 
needed in order to provide a smoothed reconstructed curves for the functional covariate
for each subject.}

\item{id}{The vector of subject id's. These tell which responses in \code{response} 
correspond to which curves in \code{object}.}

\item{response}{The vector of responses}

\item{alpha}{The alpha level for confidence intervals (one minus the two-sided coverage)}
}
\value{
Returns a list with one component for each functional 
covariate. Each such component contains the between-subjects correlations
between the fitted smoothed latent values of the functional covariate,
and the response variable. We call this a marginal correlation because
it simply ignores the other functional covariates (rather than trying to
adjust or control for them).  Both the functional regression coefficient
and the marginal correlation can be useful, although they have different
substantive interpretations.
}
\description{
Calculates marginal correlations between a functional covariate and a scalar response.
}
