% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableF.R
\name{tableF}
\alias{tableF}
\title{Frequency Table}
\usage{
tableF(.data, x, n = 20, splitby = NULL)
}
\arguments{
\item{.data}{the data frame containing the variable}

\item{x}{the bare variable name (not quoted)}

\item{n}{the number of values shown int he table}

\item{splitby}{the stratifying variable}
}
\value{
a list of class \code{tableF} containing the frequency table(s)
}
\description{
Provides in-depth frequency counts and percentages.
}
\examples{

\dontrun{

library(furniture)

data <- data.frame(
  x = sample(c(1,2,3,4), 100, replace=TRUE),
  y = rnorm(100)
)

## Basic Use
tableF(data, x)
tableF(data, y)

## Adjust the number of items shown
tableF(data, y, n = 10)

## Add splitby
tableF(data, x, splitby = y)

}

}
