% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Target.R
\name{Target}
\alias{Target}
\title{Target Class}
\description{
This class implements the target object. A \link{Target} object can only
exist as a component of a \link{Training} object.
}
\seealso{
\link{TrainLayer}, \link{Lrner}, \link{Model}, \link{TestData}
}
\section{Super class}{
\code{\link[fuseMLR:Data]{fuseMLR::Data}} -> \code{Target}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Target-new}{\code{Target$new()}}
\item \href{#method-Target-print}{\code{Target$print()}}
\item \href{#method-Target-summary}{\code{Target$summary()}}
\item \href{#method-Target-getData}{\code{Target$getData()}}
\item \href{#method-Target-getTargetValues}{\code{Target$getTargetValues()}}
\item \href{#method-Target-getTargetName}{\code{Target$getTargetName()}}
\item \href{#method-Target-getTraining}{\code{Target$getTraining()}}
\item \href{#method-Target-setData}{\code{Target$setData()}}
\item \href{#method-Target-clone}{\code{Target$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getCompleteData"><a href='../../fuseMLR/html/Data.html#method-Data-getCompleteData'><code>fuseMLR::Data$getCompleteData()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getDataFrame"><a href='../../fuseMLR/html/Data.html#method-Data-getDataFrame'><code>fuseMLR::Data$getDataFrame()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getId"><a href='../../fuseMLR/html/Data.html#method-Data-getId'><code>fuseMLR::Data$getId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getIndCol"><a href='../../fuseMLR/html/Data.html#method-Data-getIndCol'><code>fuseMLR::Data$getIndCol()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getIndSubset"><a href='../../fuseMLR/html/Data.html#method-Data-getIndSubset'><code>fuseMLR::Data$getIndSubset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getSetDiff"><a href='../../fuseMLR/html/Data.html#method-Data-getSetDiff'><code>fuseMLR::Data$getSetDiff()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getVarSubset"><a href='../../fuseMLR/html/Data.html#method-Data-getVarSubset'><code>fuseMLR::Data$getVarSubset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="impute"><a href='../../fuseMLR/html/Data.html#method-Data-impute'><code>fuseMLR::Data$impute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="setDataFrame"><a href='../../fuseMLR/html/Data.html#method-Data-setDataFrame'><code>fuseMLR::Data$setDataFrame()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Target-new"></a>}}
\if{latex}{\out{\hypertarget{method-Target-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new object from the current class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Target$new(id, data_frame, training)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character} \cr
The Object ID.}

\item{\code{data_frame}}{\code{data.frame}\cr
\code{data.frame} containing data.}

\item{\code{training}}{\code{Training} \cr
Training where to store the current object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Target-print"></a>}}
\if{latex}{\out{\hypertarget{method-Target-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Target$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Target-summary"></a>}}
\if{latex}{\out{\hypertarget{method-Target-summary}{}}}
\subsection{Method \code{summary()}}{
Summary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Target$summary(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Target-getData"></a>}}
\if{latex}{\out{\hypertarget{method-Target-getData}{}}}
\subsection{Method \code{getData()}}{
Getter of the current \code{data.frame} wihtout individual
ID nor target variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Target$getData()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{data.frame} without individual ID nor target variables is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Target-getTargetValues"></a>}}
\if{latex}{\out{\hypertarget{method-Target-getTargetValues}{}}}
\subsection{Method \code{getTargetValues()}}{
Getter of target values stored on the current training layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Target$getTargetValues()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The observed target values stored on the current training layer are returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Target-getTargetName"></a>}}
\if{latex}{\out{\hypertarget{method-Target-getTargetName}{}}}
\subsection{Method \code{getTargetName()}}{
Getter of the target variable name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Target$getTargetName()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Target-getTraining"></a>}}
\if{latex}{\out{\hypertarget{method-Target-getTraining}{}}}
\subsection{Method \code{getTraining()}}{
Getter of the current training object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Target$getTraining()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The training layer (from class \link{Training}) on which the current train data are stored
is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Target-setData"></a>}}
\if{latex}{\out{\hypertarget{method-Target-setData}{}}}
\subsection{Method \code{setData()}}{
Getter of the current \code{data.frame} wihtout individual
ID nor target variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Target$setData(data_frame)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_frame}}{\code{data.frame} \cr
data.frame to be set.

Title}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Target-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Target-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Target$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
