% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{g6_update_behavior}
\alias{g6_update_behavior}
\title{Update a behavior in a g6 graph via proxy}
\usage{
g6_update_behavior(graph, key, ...)
}
\arguments{
\item{graph}{A g6_proxy object created with \code{\link{g6_proxy}}.}

\item{key}{Character string identifying the behavior to update.}

\item{...}{Named arguments representing the behavior configuration options to update
and their new values.}
}
\value{
The g6_proxy object (invisibly), allowing for method chaining.
}
\description{
This function allows updating the configuration of an existing behavior in a g6 graph
instance using a proxy object within a Shiny application.
}
\details{
This function can only be used with a g6_proxy object within a Shiny application.
It will not work with regular g6 objects outside of Shiny.

Behaviors in G6 define how the graph responds to user interactions like dragging,
zooming, clicking, etc. This function allows dynamically updating the configuration
of these behaviors without having to reinitialize the graph.
}
\examples{
if (interactive()) {
  library(shiny)
  library(g6R)
  library(bslib)

  nodes <- data.frame(id = c("node1", "node2", "node3"))
  edges <- data.frame(source = "node1", target = "node2")

  ui <- page_fluid(
    g6_output("graph"),
    checkboxInput("enable_click_select", "Enable Click Select", value = TRUE)
  )

  server <- function(input, output, session) {
    output$graph <- render_g6({
      g6(nodes = nodes, edges = edges) |>
        g6_layout() |>
        g6_options(animation = FALSE) |>
        g6_behaviors(
          click_select()
        )
    })

    observeEvent(input$enable_click_select, {
      g6_update_behavior(
        g6_proxy("graph"),
        key = "click-select",
        enable = input$enable_click_select
      )
    })
  }

  shinyApp(ui, server)
}

}
\seealso{
\code{\link{g6_proxy}}
}
