% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_gm_formula.R
\name{parse_gm_formula}
\alias{parse_gm_formula}
\title{Parse graphical model formula}
\usage{
parse_gm_formula(
  formula,
  varnames = NULL,
  marginal = NULL,
  interactions = NULL,
  maximal_only = FALSE
)
}
\arguments{
\item{formula}{A right hand sided formula or a list.}

\item{varnames}{Specification of the variables.}

\item{marginal}{Possible specification of marginal (a set of
variables); useful in connection with model specification
shortcuts.}

\item{interactions}{The maximum order of interactions allowed;
useful in connection with model specification shortcuts.}

\item{maximal_only}{Should only maximal generators be retained.}
}
\description{
Parse graphical model formula to internal representation
}
\examples{
vn <- c("me", "ve", "al", "an", "st")

form1 <- ~me:ve:al + ve:al + an
form2 <- ~me:ve:al + ve:al + s
form3 <- ~me:ve:al + ve:al + anaba
parse_gm_formula(form1, varnames=vn)
parse_gm_formula(form2, varnames=vn)
## parse_gm_formula(form3, varnames=vn)
parse_gm_formula(form1)
parse_gm_formula(form2)
parse_gm_formula(form3)

## parse_gm_formula(~.^1)
## parse_gm_formula(~.^.)

parse_gm_formula(~.^1, varnames=vn)
parse_gm_formula(~.^., varnames=vn)
parse_gm_formula(~.^., varnames=vn, interactions=3)

vn2 <- vn[1:3]
## parse_gm_formula(form1, varnames=vn, marginal=vn2)
## parse_gm_formula(form2, varnames=vn, marginal=vn2)
## parse_gm_formula(form3, varnames=vn, marginal=vn2)
parse_gm_formula(~.^1, varnames=vn, marginal=vn2)
parse_gm_formula(~.^., varnames=vn, marginal=vn2)

}
