% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_ridge.R
\name{fit_ridge}
\alias{fit_ridge}
\title{Ridge regression estimator}
\usage{
fit_ridge(data, model_formula, to_predict)
}
\arguments{
\item{data}{Data frame containing the observed data}

\item{model_formula}{A model formula object for the ridge regression to be fitted}

\item{to_predict}{Data frame containing observations for which predictions are to be made. If NULL, defaults to the same as \code{data}.}
}
\value{
A list containing a \code{glmnet} model object \code{fit} and a vector \code{fitted} of fitted values for observations in \code{to_predict}.
}
\description{
Not typically called by the user directly; called indirectly via other functions. Uses \code{glmnet} to fit a ridge regression with penalty chosen by cross-validation. Returns fitted values for the data in \code{to_predict}.
}
\references{
Lundberg I (2021). "The gap-closing estimand: A causal approach to study interventions that close disparities across social categories." Sociological Methods and Research. Available at {https://osf.io/gx4y3/}.

Friedman J, Hastie T, Tibshirani R (2010). "Regularization Paths for Generalized Linear Models via Coordinate Descent." Journal of Statistical Software, 33(1), 1–22. {https://www.jstatsoft.org/htaccess.php?volume=33&type=i&issue=01}.
}
