% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitness.R
\name{fitnessEvolution}
\alias{fitnessEvolution}
\title{Get the evolution of the fitness}
\usage{
fitnessEvolution(
  object,
  what = c("mean", "best", "std.dev"),
  type = c("true", "raw")
)
}
\arguments{
\item{object}{The \code{\link{GenAlg}} object returned by \code{\link{genAlg}}}

\item{what}{can be one ore more of \code{"best"} (to return the fitness of the best chromosome for each generation),
\code{"mean"} (to return the arithmetic mean fitness during each generation), and \code{"std.dev"} (for
the standard deviation of the fitness values in each generation).}

\item{type}{one of \code{"true"} or \code{"raw"}. \emph{raw} means the raw fitness value used
within the GA, while \emph{true} tries to convert it to the standard error of prediction (like
\code{\link{fitness}}). If the standard deviation (\code{what = "std.dev"}) is requested, the
\code{type} will always be \emph{raw}.}
}
\value{
A vector with the best or average fitness value after each generation
}
\description{
Get the fitness of the best / average chromosomes after each generation
}
\details{
Returns the progress of the fitness of the best or average chromosome.
}
\examples{
ctrl <- genAlgControl(populationSize = 100, numGenerations = 15, minVariables = 5,
    maxVariables = 12, verbosity = 1)

evaluator <- evaluatorPLS(numReplications = 2, innerSegments = 7, testSetSize = 0.4,
    numThreads = 1)

# Generate demo-data
set.seed(12345)
X <- matrix(rnorm(10000, sd = 1:5), ncol = 50, byrow = TRUE)
y <- drop(-1.2 + rowSums(X[, seq(1, 43, length = 8)]) + rnorm(nrow(X), 1.5));

result <- genAlg(y, X, control = ctrl, evaluator = evaluator, seed = 123)

fitness(result) # Get fitness of the found subsets

h <- fitnessEvolution(result) # Get average fitness as well as the fitness of the
                              # best chromosome for each generation (at raw scale!)

plot(h[, "mean"], type = "l", col = 1, ylim = c(-7, -1))
lines(h[, "mean"] - h[, "std.dev"], type = "l", col = "gray30", lty = 2)
lines(h[, "mean"] + h[, "std.dev"], type = "l", col = "gray30", lty = 2)
lines(h[, "best"], type = "l", col = 2)
}
