% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/length_filter.R
\name{length_filter}
\alias{length_filter}
\title{Remove Length Outliers from BLAST Results}
\usage{
length_filter(Data = bin_genes, down_IQR = 1.5, up_IQR = 1.5)
}
\arguments{
\item{Data}{A data frame containing BLAST results.  Must include the columns
\code{gene} (gene symbol) and \code{length} (ORF length in amino
acids).}

\item{down_IQR}{Numeric multiplier applied to the IQR for the \strong{lower}
bound (default: 1.5).}

\item{up_IQR}{Numeric multiplier applied to the IQR for the \strong{upper} bound
(default: 1.5).}
}
\value{
The input data frame with outlier rows removed.  The returned object
is \strong{ungrouped} regardless of the input grouping.
}
\description{
Filters BLAST hits by removing ORFs whose gene (protein) length
is an outlier within the corresponding gene group, as defined
by the inter-quartile range (IQR).  Hits whose length falls
outside the interval
\code{[Q1 - down_IQR * IQR, Q3 + up_IQR * IQR]} are discarded.
}
\details{
\itemize{
\item Filtering is performed \strong{within each gene group}; outliers are determined
independently for every gene symbol.
\item Progress messages report the number of rows before and after filtering.
\item Missing values in \code{length} are ignored when computing quantiles.
}
}
