% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{TIC_integrate}
\alias{TIC_integrate}
\title{TIC integration}
\usage{
TIC_integrate(data, start_t = "first", end_t = "last")
}
\arguments{
\item{data}{a \emph{list} object. Data extracted from a cdf file,
ideally the output from extract_data().}

\item{start_t}{a \emph{float} or \emph{string} object. Value of starting time
for integration range. Default is 'first' which will start at the initial
time in the data.}

\item{end_t}{a \emph{float} or \emph{string} object. Value of ending time for
integration range. Default is 'last' which will start at the final time in
the data.}
}
\value{
A \emph{float} object. The calculated approximation of the area under
the TIC curve.
}
\description{
\code{TIC_integrate} calculates the total area under the TIC curve.
}
\details{
This function calculates the total area under the TIC curve using
Simpson's Rule area approximation. Area given in 1 flattened time dimension.
}
\examples{
file <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file,mod_t=.5)
sm_frame <- smooth(frame, lambda=10)
blc_frame <- bl_corr(sm_frame, gamma=0.5)
TIC_integrate(blc_frame)

}
