% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{writegdx.variable}
\alias{writegdx.variable}
\title{writegdx.variable}
\usage{
writegdx.variable(gdx, dt, name, valcol, uelcols, field = "l")
}
\arguments{
\item{gdx}{the gdx filename.}

\item{dt}{a data.table.}

\item{name}{name of the variable.}

\item{valcol}{name of data column.}

\item{uelcols}{vector of column names with index dimensions.}

\item{field}{the field if `type == 'variable'`}
}
\description{
Save a data.table to a variable in a GAMS gdx file.
}
\examples{
\dontrun{
dt <- as.data.table(mtcars, keep.rownames = TRUE)
tmpgdx <- file.path(tempdir(), "test.gdx")
test_var <- "mtcars"
writegdx.variable(tmpgdx, dt, test_var, valcol="wt", uelcols="rn", field="l")
new_dt <- readgdx(tmpgdx, test_var)
}
}
