% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geardf.R
\name{geardf}
\alias{geardf}
\title{Construct a \code{geardf}}
\usage{
geardf(data, coords, coordnames)
}
\arguments{
\item{data}{A data.frame}

\item{coords}{A data.frame or matrix with column names}

\item{coordnames}{The columns of \code{data} containing
the spatial coordinates, provided as a formula (e.g.,
\code{~ x + y}), column numbers (e.g., \code{c(1, 2)}),
or column names (e.g., \code{c("x", "y")}). The default
is \code{NULL}.}
}
\value{
A \code{geardf}
}
\description{
\code{geardf} constructs a \code{geardf}, which is simply
a \code{data.frame} with an attribute indicating which
columns refer to the coordinates. The function either
combines \code{x} and \code{coords} if \code{coordnames}
isn't provided, or identifies the columns of \code{x} to
which \code{coordnames} refers. The \code{geardf} class
is only provided to make plotting results of the
\code{predict.geolm*} functions simple without depending
on the \code{sp} or \code{sf} packages. See
\code{\link[gear]{plot.geardf}} for easy plotting.
}
\examples{
dtf = data.frame(a = 1:2, b = 3:4)

# create geardf with matrix coords (note column names)
coords = matrix(rnorm(4), ncol = 2)
colnames(coords) = c("u", "v")
geardf(dtf, coords)

# create geardf with data.frame coords
coords = as.data.frame(coords)
geardf(dtf, coords)

# create geardf using coordnames
dtf2 = cbind(dtf, u = rnorm(2), v = rnorm(2))
# vector form of coordnames
geardf(dtf2, coordnames = c("u", "v"))
# formula form of coordnames
geardf(dtf2, coordnames = ~ u + v)
# column index forum of coordnames
geardf(dtf2, coordnames = 3:4)

gdf = geardf(dtf2, coordnames = 3:4)
# looks like a data.frame
gdf
# but slightly more complicated
class(gdf)
attr(gdf, "coordnames")
}
\seealso{
\code{\link[gear]{plot.geardf}}
}
