% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gelnet.R
\name{gelnet.lin.obj}
\alias{gelnet.lin.obj}
\title{Linear regression objective function value}
\usage{
gelnet.lin.obj(w, b, X, z, l1, l2, a = rep(1, nrow(X)), d = rep(1, ncol(X)),
  P = diag(ncol(X)), m = rep(0, ncol(X)))
}
\arguments{
\item{w}{p-by-1 vector of model weights}

\item{b}{the model bias term}

\item{X}{n-by-p matrix of n samples in p dimensions}

\item{z}{n-by-1 response vector}

\item{l1}{L1-norm penalty scaling factor \eqn{\lambda_1}}

\item{l2}{L2-norm penalty scaling factor \eqn{\lambda_2}}

\item{a}{n-by-1 vector of sample weights}

\item{d}{p-by-1 vector of feature weights}

\item{P}{p-by-p feature-feature penalty matrix}

\item{m}{p-by-1 vector of translation coefficients}
}
\value{
The objective function value.
}
\description{
Evaluates the linear regression objective function value for a given model.
See details.
}
\details{
Computes the objective function value according to
\deqn{ \frac{1}{2n} \sum_i a_i (z_i - (w^T x_i + b))^2 + R(w) }
 where
\deqn{ R(w) = \lambda_1 \sum_j d_j |w_j| + \frac{\lambda_2}{2} (w-m)^T P (w-m) }
}
\seealso{
\code{\link{gelnet}}
}

