% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossover.R
\name{gena.crossover}
\alias{gena.crossover}
\title{Crossover}
\usage{
gena.crossover(
  parents,
  fitness = NULL,
  prob = 0.8,
  method = "local",
  par = NULL,
  iter = NULL
)
}
\arguments{
\item{parents}{numeric matrix which rows are parents i.e. vectors of 
parameters values.}

\item{fitness}{numeric vector which \code{i}-th element is the value of 
\code{fn} at point \code{population[i, ]}.}

\item{prob}{probability of crossover.}

\item{method}{crossover method to be used for making children.}

\item{par}{additional parameters to be passed depending on the \code{method}.}

\item{iter}{iteration number of the genetic algorithm.}
}
\value{
The function returns a matrix which rows are children.
}
\description{
Crossover method (algorithm) to be used in the
genetic algorithm.
}
\details{
Denote \code{parents} by \eqn{C^{parent}} which \code{i}-th row 
\code{parents[i, ]} is a chromosome \eqn{c_{i}^{parent}} i.e. the vector of 
parameter values of the function being optimized \eqn{f(.)} that is
provided via \code{fn} argument of \code{\link[gena]{gena}}.
The elements of chromosome \eqn{c_{ij}^{parent}} are genes 
representing parameters values.

Crossover algorithm determines the way parents produce children. 
During crossover each of randomly selected pairs of parents 
\eqn{c_{i}^{parent}}, \eqn{c_{i + 1}^{parent}}
produce two children 
\eqn{c_{i}^{child}}, \eqn{c_{i + 1}^{child}}, 
where \eqn{i} is odd. Each pair of parents is selected with 
probability \code{prob}. If pair of parents have not been selected
for crossover then corresponding children and parents are coincide i.e. 
\eqn{c_{i}^{child}=c_{i}^{parent}} and
\eqn{c_{i+1}^{child}=c_{i+1}^{parent}}.

Argument \code{method} determines particular crossover algorithm to 
be applied. Denote by \eqn{\tau} the vector of parameters used by the 
algorithm. Note that \eqn{\tau} corresponds to \code{par}.

If \code{method = "split"} then each gene of the first child will
be equiprobably picked from the first or from the second parent. So 
\eqn{c_{ij}^{child}} may be equal to \eqn{c_{ij}^{parent}}
or \eqn{c_{(i+1)j}^{parent}} with equal probability. The second
child is the reversal of the first one in a sense that if the first child 
gets particular gene of the first (second) parent then the second child gets
this gene from the first (second) parent i.e. if
\eqn{c_{ij}^{child}=c_{ij}^{parent}} then 
\eqn{c_{(i+1)j}^{child}=c_{(i+1)j}^{parent}}; if 
\eqn{c_{ij}^{child}=c_{(i+1)j}^{parent}} then 
\eqn{c_{(i+1)j}^{child}=c_{ij}^{parent}}.

If \code{method = "arithmetic"} then:
\deqn{c_{i}^{child}=\tau_{1}c_{i}^{parent}+
\left(1-\tau_{1}\right)c_{i+1}^{parent}}
\deqn{c_{i+1}^{child}=\left(1-\tau_{1}\right)c_{i}^{parent}+
\tau_{1}c_{i+1}^{parent}}
where \eqn{\tau_{1}} is \code{par[1]}. By default \code{par[1] = 0.5}.

If \code{method = "local"} then the procedure is the same as 
for "arithmetic" method but \eqn{\tau_{1}} is a uniform random
value between 0 and 1.

If \code{method = "flat"} then \eqn{c_{ij}^{child}} is a uniform
random number between \eqn{c_{ij}^{parent}} and 
\eqn{c_{(i+1)j}^{parent}}. 
Similarly for the second child \eqn{c_{(i+1)j}^{child}}.

For more information on crossover algorithms
please see Kora, Yadlapalli (2017).
}
\examples{
# Randomly initialize the parents
set.seed(123)
parents.n <- 10
parents <- gena.population(pop.n = parents.n,
                           lower = c(-5, -5), 
                           upper = c(5, 5))
                           
# Perform the crossover
children <- gena.crossover(parents = parents,
                           prob = 0.6,
                           method = "local")
print(children)
}
\references{
P. Kora, P. Yadlapalli. (2017). 
Crossover Operators in Genetic Algorithms: A Review.
\emph{International Journal of Computer Applications}, 162 (10), 34-36,
<doi:10.5120/ijca2017913370>.
}
