% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depMeas.R
\name{depMeas}
\alias{depMeas}
\title{depMeas Signed measure of nonlinear nonparametric dependence between two vectors.}
\usage{
depMeas(x, y, blksiz = length(x))
}
\arguments{
\item{x}{{Vector of data on the first variable}}

\item{y}{{Vector of data on the second variable}}

\item{blksiz}{{block size, default blksiz =n, where n=rows in the matrix
or no blocking is done}}
}
\value{
A measure of dependence having the same sign as Pearson correlation. Its
magnitude equals the larger of the two generalized correlation coefficients.
}
\description{
An infant may depend on the mother for survival, but not vice versa.
Dependence relations need not be symmetric, yet correlation coefficients
are symmetric. One way to measure the extent of dependence is to find
the max of the absolute values of the two asymmetric correlations
using Vinod's (2015) definition of generalized (asymmetric) correlation
coefficients.  It requires a kernel regression of x on y obtained by using 
the `np' package and its flipped version
(regress y on x).  We use a block version of
`gmcmtx0'  called `gmcmtxBlk` to admit several bandwidths for every ten
observations if the user sets blksiz=10, a recommended choice here.
}
\note{
This function needs the gmcmtxBlk function, which in turn needs the np package.
}
\examples{
library(generalCorr)
options(np.messages = FALSE)
x=1:20;y=sin(x)
depMeas(x,y,blksiz=20)

}
\references{
Vinod, H. D. `Generalized Correlation and Kernel Causality with
 Applications in Development Economics' in Communications in
 Statistics -Simulation and Computation, 2015,
 \doi{10.1080/03610918.2015.1122048}

Vinod, H. D. 'Matrix Algebra Topics in Statistics and Economics
Using R', Chapter 4 in Handbook of Statistics: Computational Statistics
with R, Vol.32, co-editors: M. B. Rao and C.R. Rao. New York:
North Holland, Elsevier Science Publishers, 2014, pp. 143-176.

Vinod, H. D. (2021) 'Generalized, Partial and Canonical Correlation
Coefficients' Computational Economics, 59(1), 1--28.
}
\seealso{
See Also \code{\link{gmcmtx0}} and \code{\link{gmcmtxBlk}}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\concept{asymmetric  p-values}
