% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artists.R
\name{get_artist_df}
\alias{get_artist_df}
\title{Retrieve metadata for an artist}
\usage{
get_artist_df(artist_id, access_token = genius_token())
}
\arguments{
\item{artist_id}{ID of the artist (\code{artist_id} within an object returned by
\code{\link{search_artist}})}

\item{access_token}{Genius' client access token, defaults to \code{genius_token}}
}
\value{
a tibble
}
\description{
The Genius API lets you search for meta data for an artist, given an
artist ID. \code{get_artist_df} returns this data in a tidy, but
reduced, format.
}
\examples{
\dontrun{
get_artist_df(artist_id = 16751)
}
}
\seealso{
See \code{\link{get_artist}} to return data in full as a list.

Other artist: 
\code{\link{get_artist_songs_df}()},
\code{\link{get_artist_songs}()},
\code{\link{get_artist}()}
}
\concept{artist}
