% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/songs.R
\name{tidy_song_producers}
\alias{tidy_song_producers}
\title{Extract producer credits from a Genius song}
\usage{
tidy_song_producers(x)
}
\arguments{
\item{x}{A \code{genius_song} object}
}
\value{
a tibble
}
\description{
Extract "producer artists" (i.e. producer credits) info from a Genius song object,
as a tidy tibble.
}
\examples{
\dontrun{
song <- get_song(song_id = 3039923)

tidy_song_producers(song)
}

}
\seealso{
See \code{\link{get_song}} to generate a Genius song object.

Other song: 
\code{\link{get_song_df}()},
\code{\link{get_song}()},
\code{\link{tidy_album_performances}()},
\code{\link{tidy_song_performances}()},
\code{\link{tidy_song_relationships}()},
\code{\link{tidy_song_writers}()}
}
\concept{song}
